<%--
 This JSP is responsible for submitting client information that we might
 find useful on the server.  The information is as follows:

  1. Available screen width, the value of the JavaScript Screen.availWidth property.
  2. Available screen height, the value of the JavaScript Screen.availHeight property.
  3. A sample of the client's Date.toString() output, to help the server deduce
     what time zone the client is running in.
  4. A flag indicating whether or not the client appears to observe
     daylight-saving-time rules.

 The "Connect" servlet dispatches to this page when the user is starting a new
 session with the HMC, but we have not retrieved client information yet.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="fetchingwindowtitle"/></hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
</head>
<body>
<fmt:message key="sendingClientInfo"/>

<script type="text/javascript">
   var now = new Date();
   var later = new Date(now.getTime()+15778800000);   // 6 months from now

   window.location.replace("/hmc/connect?<c:out value='${reqparms}' escapeXml='false'/>availableScreenSize="+
                           screen.availWidth+","+screen.availHeight+
                           "&tzOffset="+now.getTimezoneOffset()+
                           "&time="+now.getTime()+
                           "&timeString="+encodeURIComponent(now.toTimeString())+
                           "&usesDST="+(now.getTimezoneOffset() != later.getTimezoneOffset()));
</script>

</body>
</html>
</fmt:bundle>
